function comp2strains(s1n, s1, s2n, s2, normflag, forpaper) 
% This is a helper function used to compare the pumping response of 2
% different mutant strains.  s1 and s2 are the data in cell array form.
% By default, this program graphs the mean and the standard error as
% shading.

%Note that this is Nikhil's final verion of the script. I have a version
%that I modified to save the comparison with the current days date;
%subsequent to the divergence of the two scripts Nikhil added the
%"forpaper" feature - so the two scripts are somewhat different. -SRS
%6/2019

startDelay = 10;
nTimes = 3;
period = 10;
winWidth = 1000;
yMax = 6.5;  % 6.5
eventName = 'pumping rate (Hz)';
yBar = 6;    % 6
numMsInS = 1000;
%errC = 2.576; % p = 0.01
%errC = 1.960;  % p = 0.05
errC = 1;
xStart = 1;  % Set to 1/numMsInS to plot forward moving average, 1 to plot backward moving average

totalTime = startDelay + (nTimes - 1)*period;

lightc = [0 0 0] ./ 255; %[98 0 255] ./ 255;  %VIOLET %[0 32 255] ./ 255; %BLUE [0 255 37] ./ 255; % GREEN       % Color of light bar
linecm = [0 0 0; 
         % 0 0 0;
          255 51 0;
          0 100 0; %green
          0  0 255;
          ] ./ 255;  % Color of 2 mean lines
patchcm = [171 171 171; 
          %171 171 171
          255 214 126
          152 251 152 %light green
            204 204 255;
            ] ./ 255;  % Color of 2 error regions around the mean

[s1m s1sd] = eventsOverTime(s1, totalTime*numMsInS, winWidth, numMsInS, eventName, false);
s1e = s1sd / sqrt(length(s1));
s1e = errC*s1e;

[s2m s2sd] = eventsOverTime(s2, totalTime*numMsInS, winWidth, numMsInS, eventName, false);
s2e = s2sd / sqrt(length(s2));
s2e = errC*s2e;

if (normflag)
    s1norm = mean(s1m(1:startDelay*numMsInS));
    s1m = s1m/s1norm;
    s1sd = s1sd/s1norm;
    s1e = s1sd / sqrt(length(s1));
    s1e = errC*s1e;

    s2norm = mean(s2m(1:startDelay*numMsInS));
    s2m = s2m/s2norm;
    s2sd = s2sd/s2norm;
    s2e = s2sd / sqrt(length(s2));
    s2e = errC*s2e;
    yMax = 1.8;
end

figure;
hold on

x = xStart + (0:(1/numMsInS):totalTime-winWidth/numMsInS);

patch([x x(end:-1:1)], [s1m+s1e s1m(end:-1:1)-s1e(end:-1:1)], patchcm(1,:),'LineStyle','none');
patch([x x(end:-1:1)], [s2m+s2e s2m(end:-1:1)-s2e(end:-1:1)], patchcm(2,:),'LineStyle','none');

h(1) = plot(x, s1m, 'LineWidth', 2, 'Color', linecm(1,:));
h(2) = plot(x, s2m, 'LineWidth', 2, 'Color', linecm(2,:));
h(3) = plot([startDelay startDelay+period], [yBar yBar], 'LineWidth', 16, 'Color', lightc);

t = title([eventName ' for ' s2n ' (mean \pm ' num2str(errC) ' sem, n = ' ...
            num2str(length(s2)) ')'], 'FontWeight', 'bold', 'FontSize', 16);
%set(t, 'interpreter', 'none');  % Turn off _ causing subscripts
xTitle = xlabel('time (s)', 'FontWeight', 'Bold', 'FontSize', 12);
yTitle = ylabel([eventName], 'FontWeight', 'Bold', 'FontSize', 12);
prettify();
axis([xStart xStart+totalTime-winWidth/numMsInS 0 yMax]);

yts = 0:1:yMax;
set(gca, 'YTick', yts); 

%legend(h, s1n, s2n, stimn);
%text(15, yBar, 'H_2O_2',...
stimText = text(startDelay + period/2, yBar, 'UV light',...
                'FontWeight', 'bold', 'FontSize', 10, 'Color', [1 1 1], ...
                'HorizontalAlignment', 'center');
%text(12.5, yMax-.35, 'light', 'FontWeight', 'bold');

if (forpaper == 1) % Figure will be used for a paper so modify fonts and linewidths appropriately
    title('');
    set(h(3), 'LineWidth', 18);  % 20 for H2O2
    set(stimText, 'FontSize', 12);
    set(stimText, 'Position', [startDelay+period/2 yBar]);
    set(stimText, 'FontName', 'Arial');
    %set(stimText, 'FontWeight', 'normal'); %I disabled this because I didn't think it looks good -SRS 6/2019
    set(gca, 'YTickLabel', {'0','','','','','5',''});
    xlabels = {};
    oldxlabels = get(gca, 'XTickLabel');
    for i=1:length(oldxlabels)
        if(iscell(oldxlabels))
            if(mod(str2double(oldxlabels{i}), 10) == 0)
                xlabels{i} = oldxlabels{i};
            else
                xlabels{i} = '';
            end
        else
            if(mod(str2double(oldxlabels(i,:)), 10) == 0)
                xlabels{i} = oldxlabels(i,:);
            else
                xlabels{i} = '';
            end
        end
    end
    set(gca, 'XTickLabel', xlabels);
    set(gca, 'FontSize', 17);
    set(gca, 'FontName', 'Arial');
    set(xTitle, 'FontSize', 21);
    set(xTitle, 'FontName', 'Arial');
    set(xTitle, 'FontWeight', 'normal');
    set(yTitle, 'FontSize', 21);
    set(yTitle, 'FontName', 'Arial');
    set(yTitle, 'FontWeight', 'normal');    
    set(gca, 'LineWidth', 2.3); %increasing this from 1.13 to comply with Neuron's guidelines for no lines less than 0.5 pt 6/30/2019. This assumes that the bitmap will be pasted into inkscape and then reduced to 25% (alternatively, the "metafile" copy can be used and then scale up by 165%) - SRS

    %{
    % Decide where to place the names of the strains being compared
    left1 = length(s1m)-10*winWidth;
    max1 = max(s1m(left1:end));
    min1 = min(s1m(left1:end));
    left2 = length(s2m)-10*winWidth;
    max2 = max(s2m(left2:end));
    min2 = min(s2m(left2:end));
    if(min1 > 1) % there is space to put the label below
        y1 = min1 - 0.75;
        y2 = max2 + 0.25;
    else
        y1 = max1 + 0.25;
        if(min2 > 1 && min2-0.75 < y1-1 && min2-0.75 > y1+1)
            y2 = min2 - 0.75;
        elseif (max2+0.25 < y1+1)
            y2 = max2 + 1.25;
        else
            y2 = max2 + 0.25;
        end
    end
    text(x(end), y1, s1n, ...
         'FontSize', 21, 'Color', linecm(1,:), ...
         'HorizontalAlignment', 'right', 'VerticalAlignment', 'bottom');
    text(x(end), y2, s2n, ...
         'FontSize', 21, 'Color', linecm(2,:), ...
         'HorizontalAlignment', 'right', 'VerticalAlignment', 'bottom');
    %}
elseif (forpaper == 2)  % figure will be used for preso
    set(h(3), 'LineWidth', 24);  % 20 for H2O2
    set(stimText, 'FontSize', 17);
    set(stimText, 'Position', [startDelay+period/2 yBar+0.01]);
    set(stimText, 'FontName', 'Arial');
    set(stimText, 'FontWeight', 'bold');
    %set(gca, 'YTickLabel', {'0','','','','','5',''});
    %{
    xlabels = {};
    oldxlabels = get(gca, 'XTickLabel');
    for i=1:length(oldxlabels)
        if(iscell(oldxlabels))
            if(mod(str2double(oldxlabels{i}), 10) == 0)
                xlabels{i} = oldxlabels{i};
            else
                xlabels{i} = '';
            end
        else
            if(mod(str2double(oldxlabels(i,:)), 10) == 0)
                xlabels{i} = oldxlabels(i,:);
            else
                xlabels{i} = '';
            end
        end
    end
    set(gca, 'XTickLabel', xlabels);
    %}
    set(gca, 'FontSize', 16);
    set(gca, 'FontName', 'Arial');
    set(xTitle, 'FontSize', 18);
    set(xTitle, 'FontName', 'Arial');
    set(xTitle, 'FontWeight', 'Bold');
    set(yTitle, 'FontSize', 18);
    set(yTitle, 'FontName', 'Arial');
    set(yTitle, 'FontWeight', 'Bold');    
    set(gca, 'LineWidth', 2);
    set(gcf, 'Position', [100 100 1366 730]);
    %set(gcf, 'Position', [100 100 1500 1150]);
    title('');
elseif (forpaper == 3)  % figure will be used for preso as 2x2 on a slide
    set(h(3), 'LineWidth', 36);  % 20 for H2O2
    set(stimText, 'FontSize', 30);
    set(stimText, 'Position', [startDelay+period/2 yBar+0.01]);
    set(stimText, 'FontName', 'Arial');
    set(stimText, 'FontWeight', 'bold');
    set(gca, 'YTickLabel', {'0','','','','','5',''});
    xlabels = {};
    oldxlabels = get(gca, 'XTickLabel');
    for i=1:length(oldxlabels)
        if(iscell(oldxlabels))
            if(mod(str2double(oldxlabels{i}), 10) == 0)
                xlabels{i} = oldxlabels{i};
            else
                xlabels{i} = '';
            end
        else
            if(mod(str2double(oldxlabels(i,:)), 10) == 0)
                xlabels{i} = oldxlabels(i,:);
            else
                xlabels{i} = '';
            end
        end
    end
    set(gca, 'XTickLabel', xlabels);
    set(gca, 'FontSize', 26);
    set(gca, 'FontName', 'Arial');
    set(xTitle, 'FontSize', 30);
    set(xTitle, 'FontName', 'Arial');
    set(xTitle, 'FontWeight', 'Bold');
    set(yTitle, 'FontSize', 30);
    set(yTitle, 'FontName', 'Arial');
    set(yTitle, 'FontWeight', 'Bold');    
    set(gca, 'LineWidth', 2);
    set(gcf, 'Position', [100 100 1500 1150]);
end

prettify();

end